// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
|==========||==========|
GS Shader 2.1

By Goldshadow12
|==========||==========|
*/

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300
    #if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
        _centroid in highp vec2 uv;
    #else
        _centroid in vec2 uv;
    #endif

#else
    varying vec2 uv;
#endif

#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"
#include "uniformRenderChunkConstants.h"
#include "util.h"

in highp vec3 position;
in highp vec3 wPos;

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;

void main() {
    
    #if !defined(TEXEL_AA) || !defined(TEXEL_AA_FEATURE)
    	vec4 diffuse = texture2D( TEXTURE_0, uv );
    #else
    	vec4 diffuse = texture2D_AA(TEXTURE_0, uv );
    #endif

    vec4 fc = FOG_COLOR;
    
    float dusk = pow(max(min(1.0-fc.b * 1.2, 1.0), 0.0), 0.5);
    float night = pow(max(min(1.0-fc.r * 1.5, 1.0), 0.0), 1.2);
    float rain = (1.0 - pow(FOG_CONTROL.y, 11.0));
    
    float size = mix(1.2,1.,night);
    
    vec2 pos = position.xz*size;
    
    float lp = length(pos);
    
    
    
    vec3 final_col = mix(mix(vec3(1.0,0.8,0.3), vec3(1.0,0.55,0.0)+fc.r, dusk), vec3(1.0) + fc.r + fc.g, night);
    
    diffuse.rgb *= final_col;
    
    diffuse.rgb += mix(vec3(.0), vec3(.2), 1.-smoothstep(.0,.65,lp*1.2));
    
    gl_FragColor = diffuse;
	gl_FragColor.a = 1.0*(1.0-rain);
}
